/*

Isolate Inverse Selection Script File
Created:  		July 31 2001
Author:   Pete Samson


Isolate Inverse Selection Functions
This script creates functions for Isolating  unselected geometery and 
basically inverses the selection and call the Isolate Selection script 
***********************************************************************************************/

MacroScript Isolate_Inverse_Selection
Category:~ISOLATE_INVERSE_SELECTION_CATEGORY~ 
internalCategory:"Tools" 
ToolTip:~ISOLATE_INVERSE_SELECTION_TOOLTIP~ 
buttontext:~ISOLATE_INVERSE_SELECTION_BUTTONTEXT~ 
Icon:#("ViewPortNavigationControls",7) 
SilentErrors:True
(

	on isEnabled return(selection.count > 0 and (subObjectLevel == 0 or subObjectLevel == undefined))
			
	on execute do with undo off
	(
		-- saves the current selection filter (all, lights, geometry etc...)
		local SavedSelectionFilter
		SavedSelectionFilter = GetSelectFilter()

		--set the selection filter to all in order to provide an efficient Isolation tool
		SetSelectFilter 1
		if (isSelectionFrozen() == true)do thawSelection() ---pfb feb 10 2003, tool was failing when selection is locked
		max select invert
		IsolateSelection.EnterIsolateSelectionMode()
		max select none
		
		--restores the previously saved selection filter
		SetSelectFilter SavedSelectionFilter
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAZ5d+L0btdLjVZPHHSsDZUxVdlUhyWEGI9
-- gc8ArxSVQpbAS+YzkP4Y4QgbLw5mpOnl6oDfNGklUS5ClcCw0s6VCv1CNnxjS7KN
-- Vj/DCdWSo3EKFUcCCHgEVEXnnFwRB/KIzuuxG4TQnOcC7FBuENxk1mqZubNhgOLS
-- FwBAVtFAOkkBV/nDdc3PEWjffgv9VXIbL5FjxjD5tO9rByKr9oT9PAkfm/1W3Cxi
-- XBDOs0G7nTvDXf+crMiBTOvnXgLwz+zcCgCJEC1f9GY2h+bBiP5ucSuwUwk2HzHZ
-- 7BeAYcc8CelNJ2JhDU8RgPCmDFwHvtKprlQx/JRL/bskmZevhNC9
-- -----END-SIGNATURE-----